package gov.va.vinci.dart;

import org.springframework.security.core.context.SecurityContextHolder;
import org.testng.Assert;
import org.testng.annotations.BeforeTest;
import org.testng.annotations.Test;

import gov.va.vinci.dart.common.SingletonShim;
import gov.va.vinci.dart.common.json.ErrorView;
import gov.va.vinci.dart.common.test.BusinessIntegrationTest;
import gov.va.vinci.dart.biz.Request;
import gov.va.vinci.dart.json.ActivityIdView;
import gov.va.vinci.dart.json.CreateActivityView;
import gov.va.vinci.dart.json.EventHistoryView;
import gov.va.vinci.dart.json.EventRequestView;
import gov.va.vinci.dart.json.EventView;
import gov.va.vinci.dart.json.NewActivityView;
import gov.va.vinci.dart.json.RequestIdView;
import gov.va.vinci.dart.service.DartObjectFactory;
import gov.va.vinci.dart.usr.CustomAuthentication;

public class TestEventController extends BusinessIntegrationTest {

	@BeforeTest
	public void setup() {
		SingletonShim.getBean(DartObjectFactory.class);
		
		CustomAuthentication token = new CustomAuthentication("DNS", null, "password", "details", "principal");

		try {
			DartObjectFactory.getInstance().getUserManager().login(token);
			SecurityContextHolder.getContext().setAuthentication(token);
		} 
		catch (Exception e) {
			e.printStackTrace();
		}
	}
	
	@Test
	public void testOne() throws Exception {

		CreateActivityView req = new CreateActivityView ();
		
		ActivityController ac = SingletonShim.getBean(ActivityController.class);
		req.setType(Request.DATA_ACCESS);
		req.setOfficialName("official name");
		
		// now see if we can create it correctly
		Object obj = ac.createActivity(req);
		Assert.assertNotNull(obj);
		Assert.assertTrue(obj instanceof NewActivityView);
		
		NewActivityView nav = (NewActivityView)obj;
		Assert.assertTrue(nav.getActivityId() > 0);
		Assert.assertTrue(nav.getRequestId() > 0);
		
		// now we have a request to work with
		
		EventController ec = SingletonShim.getBean(EventController.class);

		ActivityIdView aiv = new ActivityIdView();
		aiv.setActivityId(nav.getActivityId());
		
		obj = ec.listEventsByActivity(aiv);
		Assert.assertNotNull(obj);
//		Assert.assertTrue(obj instanceof EventHistoryView);
//		
//		EventHistoryView ehv = (EventHistoryView)obj;
//		Assert.assertNotNull(ehv.getRequests());
//		Assert.assertEquals(ehv.getRequests().size(), 1);
//		
//		EventRequestView erv = ehv.getRequests().get(0);
//		Assert.assertNotNull(erv);
//		Assert.assertEquals(erv.getRequestId(), nav.getRequestId());
//		Assert.assertNotNull(erv.getTrackingNumber());
//		Assert.assertFalse(erv.isAmendment());
//		
//		Assert.assertNotNull(erv.getEvents());
//		Assert.assertEquals(erv.getEvents().size(), 0);  // there are no events yet - submit would be the first.
//		
//		
//		RequestController rc = SingletonShim.getBean(RequestController.class);
//		
//		// submit the request
//		RequestIdView riv = new RequestIdView();
//		riv.setRequestId(nav.getRequestId());
//		riv.setUserId(1006);
//		
//		obj = rc.submitRequest(riv); 
//		 
//		Assert.assertNotNull(obj);
//		Assert.assertTrue(obj instanceof ErrorView);
//		ErrorView ev = (ErrorView)obj;
//		Assert.assertEquals("OK", ev.getMessage().get("text"));
//
//
//		// now there should be an event.  let's go find it
//		obj = ec.listEventsByActivity(aiv);
//		Assert.assertNotNull(obj);
//		Assert.assertTrue(obj instanceof EventHistoryView);
//		ehv = (EventHistoryView)obj;
//		Assert.assertNotNull(ehv.getRequests());
//		erv = ehv.getRequests().get(0);
//		Assert.assertNotNull(erv);
//		Assert.assertNotNull(erv.getEvents());
//		
//		Assert.assertEquals(erv.getEvents().size(), 1);  // request submitted
//
//		boolean bSubmitted = false;
//		boolean bInitial = false;
//		for (EventView ev2 : erv.getEvents()) {
//			Assert.assertNotNull(ev2);
//			Assert.assertNotNull(ev2.getDescription());
//			Assert.assertNotNull(ev2.getDateTime());
//			Assert.assertNotNull(ev2.getPerson());
//			if (ev2.getDescription().indexOf("Submit") >= 0) {
//				bSubmitted = true;
//			}
//			else if (ev2.getDescription().indexOf("Initial") >= 0) {
//				bInitial = true;
//			}
//		}
//
//		Assert.assertTrue(bSubmitted);
	}
}
